﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.Operations;
using BMS.VistaIntegration.Commands;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Managers;
using BMS.VistaIntegration.Audit;
using BMS.VistaIntegration.Dal;
using BMS.Schedulers;
using BMS.Schedulers.Managers;
using BMS.VistaIntegration.Dal.Schedulers;
using System.Threading;


namespace BMS.VistaIntegration
{
    public class Crawler
    {
        private bool isStarted = false;
        public IOperationManager OperationManager { get; private set; }
        public IWriterManagerFactory WriterManagerFactory { get; private set; }
        public SchedulerDal SchedulerDal { get; private set; }
        public CancellationTokenSource CancellationTokenSource { get; private set; }
        private readonly ISessionFactory sessionFactory;

        public Crawler(
            IWriterManagerFactory writerManagerFactory,
            ISessionFactory sessionFactory,
            IOperationManager operationManager)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.CancellationTokenSource = new CancellationTokenSource();
                this.WriterManagerFactory = writerManagerFactory;
                //this.sessionFactory = new ShareSessions.SessionFactory(sessionFactory);
                this.sessionFactory = sessionFactory;
                this.SchedulerDal = new SchedulerDal(this.sessionFactory);
                this.OperationManager = operationManager;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void StartVistASyncronization()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (isStarted)
                    throw new InvalidOperationException();

                isStarted = true;
                RefreshCommands();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void EndVistASyncronization()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!isStarted) return;
                SchedulerManager.Instance.RemoveCommands<RunSchedulerCommand>();
                CancellationTokenSource.Cancel();
                OperationManager.Dispose();
               // this.sessionFactory.MdwsSessionFactory.Clear();
               // this.sessionFactory.OdbcSessionFactory.Clear();
                OperationManager = null;
                isStarted = false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void CheckWasStarted()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!isStarted)
                    throw new InvalidOperationException("VistA integration not started");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RunOnDemandCommand MakeRunOnDemandCommand(DataRetrievalMethod dataRetrivalMethod)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                CheckWasStarted();
                RunOnDemandCommand command = new RunOnDemandCommand(this, sessionFactory.MakeSession(dataRetrivalMethod));
                return command;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public TestConnectionCommand MakeTestConnectionCommand(IVistASessionFactory sessionFactory)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                CheckWasStarted();
                TestConnectionCommand command = new TestConnectionCommand(sessionFactory);
                return command;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        public void RefreshCommands()
        {

            CheckWasStarted();
            //sessionFactory.MdwsSessionFactory.Clear();
            //sessionFactory.OdbcSessionFactory.Clear();
            Dictionary<string, RunSchedulerCommand> schedulersCommands = SchedulerDal.GetSchedulersCommand()
                .ToDictionary(s => s.SchedulerId, s => new RunSchedulerCommand(this, s.schedulerData));

            SchedulerManager.Instance.SetCommands<RunSchedulerCommand>(schedulersCommands);

        }

    }
}
